/*
1)DMX用ライブラリ"PlayDMX"をフォルダごと、"Arduino/libraries"フォルダの中に置いてください。
-----ArduinoMegaの場合は、ライブラリ"PlayDMXmega"を使用してください。-----
2)Ethernet用ライブラリ"Ethernet2"を、IDEのライブラリマネージャからインストールしてください。
3)スケッチをボードに書き込んでいる間は、D0(RX)ピンとトランシーバICの間は開放してください。
*/

#include <PlayDMX.h> //ArduinoUno
//#include <PlayDMXmega.h> //ArduinoMega
#include <SPI.h>       
#include <Ethernet2.h>
#include <EthernetUdp2.h>

PlayDMX DMX; //ArduinoUno
//PlayDMXmega DMX; //ArduinoMega
EthernetUDP Udp;


//Arduino のネットワーク設定
const IPAddress ip(192, 168, 1, 100);         //IPアドレス
const IPAddress myDns(192, 168, 1, 1);        //DNS
const IPAddress gateway(192, 168, 1, 1);      //ゲートウエイ
const IPAddress subnetmask(255, 255, 255, 0); //サブネットマスク

//EthernetShield2 のMACアドレス入力
uint8_t mac[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}; //MACアドレス

//DMX の設定
const int DMX_address = 1; //DMXアドレス

//UDP の設定
const IPAddress remoteIP (255,255,255,255); //送信先IPアドレス
const int remotePort = 6999;                //送信先ポート番号
const int localPort = 8000; //ローカルポート番号

//グローバル変数
char* Message[] = {"low","high"}; //送信するメッセージ
bool State;


void setup(){
  Ethernet.begin(mac, ip, myDns, gateway, subnetmask);
  Udp.begin(localPort);
  
  if(DMX.read(DMX_address) >127)State =1;
}

void loop(){
  int DMX_buffer = DMX.read(DMX_address);
  
  if(DMX_buffer >127 && State ==0)sendUDP();
  else if(DMX_buffer <=127 && State ==1)sendUDP();
}

void sendUDP(){
  State = !State;
  Udp.beginPacket(remoteIP, remotePort);
  Udp.write(Message[State]);
  Udp.endPacket();
}
