/*
1)DMX用ライブラリ"PlayDMX"をフォルダごと、"Arduino/libraries"フォルダの中に置いてください。
-----ArduinoMegaの場合は、ライブラリ"PlayDMXmega"を使用してください。-----
2)Artnet用ライブラリ"ArtNet"を、IDEのライブラリマネージャからインストールしてください。
3)スケッチをボードに書き込んでいる間は、D0(RX)ピンとトランシーバICの間は開放してください。
*/

#include <PlayDMX.h> //ArduinoUno
//#include <PlayDMXmega.h> //ArduinoMega
#include <Artnet.h> //v0.1.0にて動作は確できております。

PlayDMX DMX; //ArduinoUno
//PlayDMXmega DMX; //ArduinoMega
ArtnetReceiver artnet;


//Arduino のネットワーク設定
const IPAddress ip(2, 1, 1, 100);         //IPアドレス
const IPAddress myDns(2, 1, 1, 1);        //DNS
const IPAddress gateway(2, 1, 1, 1);      //ゲートウエイ
const IPAddress subnetmask(255, 0, 0, 0); //サブネットマスク

//EthernetShield2 のMACアドレス入力
uint8_t mac[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}; //MACアドレス

//Artnet の設定
uint8_t net = 0;      //ネット
uint8_t subnet = 0;   //サブネット
uint8_t universe = 0; //ユニバース


void callback(uint8_t* data, uint16_t size){
  for (size_t i = 0; i < size; ++i){
    DMX.write(i+1  , data[i]);
  }
}

void setup(){
  Ethernet.begin(mac, ip, myDns, gateway, subnetmask);
  
  artnet.begin();
  artnet.subscribe(net, subnet, universe, callback);
}

void loop(){
  artnet.parse();
}
