#include <avr/io.h>
#include <avr/interrupt.h>
#include "PlayDMXmega.h"

static volatile char TX_STATE, RX_STATE ;
static volatile int TX_ADD, RX_ADD;
static unsigned char TX_VAL[MAX_CH];
static unsigned char RX_VAL[MAX_CH];


PlayDMXmega::PlayDMXmega () {
    int i;

    for (i = 1; i < MAX_CH; i ++) {
        TX_VAL[i] = 0;
        RX_VAL[i] = 0;
    }
    TX_STATE = STATE_1;
    RX_STATE = STATE_1;

    UBRR0 = F_CPU / 8 / 250000 - 1;
    UCSR0A = _BV(RXC0) | _BV(U2X0);
    UCSR0C = _BV(USBS0) | _BV(UCSZ01) | _BV(UCSZ00);
    UCSR0B = _BV(RXCIE0) | _BV(RXEN0) | _BV(TXEN0);

    TCNT2 = 0;
    OCR2A = F_CPU / 64 / 10000 - 1;
    TCCR2A = _BV(WGM21);
    TCCR2B = _BV(CS22);
    TIMSK2 = _BV(OCIE2A);

    PORTE |= _BV(1);
    DDRE |= _BV(1);

}

void PlayDMXmega::write (int ADD, unsigned char VAL) {
    TX_VAL[(ADD-1)] = VAL;
}

unsigned char PlayDMXmega::read (int ADD) {
    return RX_VAL[(ADD-1)];
}

//
ISR(TIMER2_COMPA_vect) {

    if (UCSR0B != _BV(RXCIE0) | _BV(RXEN0) | _BV(TXEN0)) {
        UCSR0B = _BV(RXCIE0) | _BV(RXEN0) | _BV(TXEN0);
    }

    switch (TX_STATE) {
    case STATE_1:
        TCCR2B = 0;
        PORTE &= ~_BV(1); 
        UCSR0B &= ~_BV(TXEN0);
        TX_STATE = STATE_2;
        OCR2A = F_CPU / 64 / 10000 * TIME_1 - 1;
        TCCR2B = _BV(CS22);
        break;

    case STATE_2:
        TCCR2B = 0;
        PORTE |= _BV(1);
        UCSR0B |= _BV(TXEN0);
        TX_STATE = STATE_3;
        OCR2A = F_CPU / 64 / 10000 * TIME_2 - 1;
        TCCR2B = _BV(CS22);
        break;

    case STATE_3:
        TCCR2B = 0;
        TX_ADD = 0;
        TX_STATE = STATE_4;
        UCSR0B |= _BV(UDRIE0);
        UDR0 = 0;
        break;
    }
}

//
ISR(USART0_UDRE_vect) {
    if (TX_STATE == STATE_4) {
        UDR0 = TX_VAL[TX_ADD];
        TX_ADD ++;
        
        if (TX_ADD >= MAX_CH) {
            UCSR0B &= ~_BV(UDRIE0);
            TX_STATE = STATE_1;
            OCR2A = F_CPU / 64 / 10000 * TIME_3 - 1;
            TCCR2B = _BV(CS22);
        }
    }
}

//
ISR(USART0_RX_vect) {
    int flg, dat;

    flg = UCSR0A;
    dat = UDR0;

    if (flg & 0x0c) {
        RX_STATE  = STATE_5;
        while (UCSR0A & _BV(RXC0)) { dat = UDR0; }
        return;
    } else
    if (flg & 0x10) {
        RX_STATE  = STATE_2;
        return;
    }

    if (RX_STATE  == STATE_2) {
        if (dat == 0) {
            RX_ADD = 0;
            RX_STATE  = STATE_4;
        } else {
            RX_STATE  = STATE_5;
        }

    } else
    if (RX_STATE  == STATE_4) {
        RX_VAL[RX_ADD] = dat;
        RX_ADD ++;
        
        if (RX_ADD >= MAX_CH) {
            RX_STATE  = STATE_1;
        }
    }
}
