/*  "sketch.2017;"samplePlay09_voluminBasic:v.1.0

「スイッチを押しているときに、LEDが光ったり、ブザーから音が出る」
「そのLEDの明るさやブザーの音階は、ボリュームの向きで変わる」
そんなスケッチを作って、ボードを楽器にしてしまいましょう。

play08までに使ったコマンドだけで作ったスケッチです。

いざ、プレイ！！
*/
              
  int vlm = 0;
  int val;
  int sw = 2;
  int ao = 10;
  int midori = 9;
  int kiiro = 6;
  int aka = 5;
  int bz = 3;

void setup() {
  pinMode(sw,INPUT);
  pinMode(ao,OUTPUT);
  pinMode(midori,OUTPUT);
  pinMode(kiiro,OUTPUT);
  pinMode(aka,OUTPUT);
}

void loop() {
  val =analogRead(vlm);  
  if(digitalRead(sw) == LOW){
    analogWrite(midori, val/4);
    analogWrite(kiiro, val/4);
    analogWrite(aka, val/4);
    analogWrite(ao, (255-val/4));
    tone(bz,val/2);
  }
  else{
    analogWrite(ao, 0);
    analogWrite(midori, 0);
    analogWrite(kiiro, 0);
    analogWrite(aka, 0); 
    noTone(bz);
  }
}


/*
[このサンプルスケッチは、Arduino IDE 1.8.5(Windows)で作成しました。]
＊IDEの[ファイル]>[環境設定]>[設定]タブ>"検証または書き込みを行う前にスケッチを保存する"にチェックがあると、
  自動保存で上書きされます。好みで使い分けてください。
*/
