/*  "sketch.2017;"samplePlay08_volume:v.1.0

「つまみを回すと、青色LEDの明るさが変わったり、ブザーの音階が変わる」スケッチを作りましょう。

スイッチは「押す/離す」の2つの状態しかありませんでした。
でも、つまみの場合は、「つまみの矢印がどこに向いているか」を知る必要がありますね。

ちなみに、つまみの事は「ボリューム」と呼ぶ事にします。カタカナの方がカッコ良さそうですし。
*/
              
  int vlm = 0;//ボリュームと言う事で"vlm"と言う変数を作り、ボード上でボリュームと繋がっているピン番号"0"を入れます。
  int val;//読み取ったボリュームの値を入れておく為の、"val"と言う変数を作っておきます。
  int ao = 10;
  int bz = 3;

void setup() {
  pinMode(ao,OUTPUT);
  
  //＊ボリュームに使うピンも、モード設定をする必要がありません。
}

void loop() {
  val = analogRead(vlm);//valの中に、ボリュームの矢印の向きを数字として入れます。＊詳しくはあとで 
  analogWrite(ao, val/4);//valを4で割った値で青色LEDを光らせます。
  tone(bz,val/2);//valを2で割った値でブザーを鳴らします。
}



/*
コマンド"analogRead"で、ボリュームの矢印の向きを数字として調べる事ができます。
左回りの回しきりが "0"
右回りの回しきりが "1023"

青色LEDを光らせるコマンド"analogWrite"で指定できる最大の数字が255なので、valを4で割った値を指定しています。
ブザーの音の数については、2で割ると、ボリュームの真ん中から右回りまわしきりが、下の"ド"から、上の"ド"の音の幅に近くなって
遊びやすいからです。

このスケッチでボードが動いていると、そろそろブザーがうるさく感じてきたでしょう。
寄り道せずに、最後のplay09へ。

[このサンプルスケッチは、Arduino IDE 1.8.5(Windows)で作成しました。]
＊IDEの[ファイル]>[環境設定]>[設定]タブ>"検証または書き込みを行う前にスケッチを保存する"にチェックがあると、
  自動保存で上書きされます。好みで使い分けてください。
*/
