/*  "sketch.2017;"samplePlay07_switch:v.1.0

「スイッチを押しているとき、青色LEDが光って、ブザーから音が出る。離すと青色LEDは消えて、ブザーも止まる」スケッチを作ります。

ちょっとした「インタラクティブ」ですね。
*/

  int sw = 2;//スイッチと言う事で"sw"と言う変数を作り、ボード上でスイッチと繋がっているピン番号"2"を入れます。
  int ao = 10;
  int bz = 3;
  int ra = 440;

void setup() {
  pinMode(sw,INPUT);//スイッチの場合、ボードに伝える側と言う意味で、"INPUT"(インプット)に設定します。
  pinMode(ao,OUTPUT);
}

void loop() {
  if(digitalRead(sw) == LOW){ //もし、スイッチを押されていたら、、、
    digitalWrite(ao,HIGH);  //  1)青色LEDが光ります。
    tone(bz,ra);            //  2)ブザーから"ラ"の音が出ます。
  }                         // －ここまで。
  
  else{                     //そうじゃなければ（スイッチが押されてなければ）、、、
    digitalWrite(ao,LOW);   //  1)青色LEDが消えます。
    noTone(bz);             //  2)ブザーの音が止まります。
  }                         // －ここまで。
}



/*
コマンド"if"では、指定した条件について確認をする事ができます。
今回は、スイッチの状態を読み取るコマンド"digitalRead"と合わせて使うことで、「スイッチが押されているか？」の条件を確認しています。

ざっくばらんな話し、ここでは、、、
 if(digitalRead(sw) == LOW){　「スイッチが押されているか？」を確認できます。
 if(digitalRead(sw) == HIGH){ 「スイッチが離されているか？」を確認できます。

"if"は色んなところで使えますけど、まずはスイッチの確認に限定して使っていきましょう。

コマンド"else"は、"if"と一緒に使います。


久しぶりに、寄り道して、、、
「スイッチが離されているとき、青色LEDが光って、ブザーから音が出る。押すと青色LEDは消えて、ブザーが止まる」スケッチに書換えてみましょう。
＊つまり、スイッチと、LEDやブザーの動きが、今と逆になるスケッチです。
(書き換えるとき、//の後ろはそのままでOKです。)

[このサンプルスケッチは、Arduino IDE 1.8.5(Windows)で作成しました。]
＊IDEの[ファイル]>[環境設定]>[設定]タブ>"検証または書き込みを行う前にスケッチを保存する"にチェックがあると、
  自動保存で上書きされます。好みで使い分けてください。
*/
