/*  "sketch.2017;"samplePlay01_aoBlink:v.1.0

－注釈の表現－
1.Arduinoと、sketch.2017;は、２つを組み合わせた状態で使用します。ここでは組み合わせた状態を「ボード」と表記します。

2.Arduinoで使うプログラムは、世界中の人が「スケッチ」と呼んでいます。ここではカタカナで「スケッチ」と表記します。

3.ボードで動かしたいことや、ボードに覚えさせたい事などは、ひとつずづ命令を出します。その命令を、ここでは「コマンド」と表記します。

＊これらには、もっと細かい表現があったりしますが、サンプルスケッチの注釈では、この表現で統一します。


－スケッチの基本ルール－
1.コマンドにつかえる文字は、半角英数字のみです。

2.コマンドにつかう文字は、大文字で書くところと、小文字で書くところが決まっています。

3.コマンドを書いた行の最後には、基本的に";"（セミコロン）を書いて、「エンターキー」を押します。
  ところが、";"(セミコロン)を必要としない場合もあったりするので注意が必要です。（Ｔ＿Ｔ）

4."/"(スラッシュ）"*"(アスタリスク)の連続から、"*"(アスタリスク)"/"(スラッシュ)の連続の間に書かれている事は、ボードは無視します。
  なので、その間では、この説明書きの様に全角日本語も使えます。＼（＾〇＾）／

5."/"(スラッシュ)"/"(スラッシュ)と連続で書くと、その後ろに書いてある事は、次の行までボードは無視します。

ここまで読んで、書いてある事が分かってなくても、実は大丈夫です。
徐々にやっていって、何か困ったらあとで読み返しましょう。

はい。では、はじめにボードの青色LEDを点滅させてみましょう。
*/

//"void setup()" (ボイド セットアップ)では、ボードが動き始める時に、"{"(始め波カッコ)と"}"(終わり波カッコ)の中に書いたコマンドが、上の行から下の行へ順に１度だけ動きます。

void setup() {
  pinMode(10,OUTPUT);//青色LEDは、ボードの10番ピンとつながっています。10番ピンから電気を出したいので、"OUTPUT"(アウトプット)に設定します。
}


//"void loop()" (ボイド ループ)では、void setup()の次に、"{"と"}"の中に書いたコマンドが、上の行から下の行へ順に動きます。
//一番下のプログラムが動き終わったら、上のプログラムに戻って繰り返して動きます。

void loop() {
  digitalWrite(10,HIGH);//10番ピンから電気を出します。青色LEDが光ります。＼（＾〇＾）／
  delay(1000);//1秒間、動きを止めます。（・－・）
  digitalWrite(10,LOW);//10番ピンから電気を出しません。青色LEDが消えます。（－．－）Ｚｚｚ
  delay(1000);//1秒間、動きを止めます。（・－・）
}



/*
LEDを光らせたい場合は、そのLEDがつながっているボードのピンを、set up()の中で、コマンド"pinMode"を使ってアウトプットに設定します。

LEDを光らせるときも、消すときも、コマンド"digitalWrite"を使います。

コマンド"delay"は、指定した時間だけボードの動きが止まります。指定する数字は"ミリ秒"と言う単位で、例えば1秒は1000、2秒が2000、0.5秒は500、と言う感じです。


play02の前に、寄り道して、「黄色LEDが、2秒間光って、0.5秒間消えて点滅する」スケッチに書換えてみましょう。
(書き換えるとき、//の後ろはそのままでOKです。)

[このサンプルスケッチは、Arduino IDE 1.8.5(Windows)で作成しました。]
＊IDEの[ファイル]>[環境設定]>[設定]タブ>"検証または書き込みを行う前にスケッチを保存する"にチェックがあると、
  自動保存で上書きされます。好みで使い分けてください。
*/
