/*  "sketch.2017;"samplePlay00_game:v.1.0

－LEDの光の動きに合わせてスイッチを押す「リズムゲーム」です。－

  －ルール－
1.緑色＞黄色＞赤色＞青色の順番にLEDが光るので、青色のLEDが光っている時に、スイッチを押せたら成功です。
　成功すると、"ピッ"とブザーが鳴ります。

2.成功するたびに、LEDの動きが少しづつ早くなります。

3.5回連続で成功すると、ゲームクリアです！
　ゲームクリアすると、"ピーー"とブザーが鳴りながら、LEDが逆周りで点滅します！

4.青色のLEDが光っているあいだに、スイッチを押さなかったらゲームオーバーです。
　"ブー"とブザーが鳴って、始めからやり直しです。。

5.そして、青色以外のLEDが光っているあいだに、スイッチを押してもゲームオーバーです。
　"ブー"とブザーが鳴って、始めからやり直しです。。

注意:成功しても、長くスイッチを押していると、緑色のLEDが光りはじめてゲームオーバーになります。
     短くスイッチを押すのがコツです。

  －遊び方－
1.つまみの矢印が、中心より右側に向いているとゲームスタートします。
  ゲーム中はつまみを回さないでください。

2.ゲーム時間は30秒間です。30秒経過するとゲームは終了となり、全てのLEDが点滅します。

3.ゲームが終了したら、つまみの矢印を中心より左側に回して、ふたたび右側に回すとゲームが始まります。

4.30秒間に、何回ゲームクリアできるかを挑戦してみましょう。


  －高度な遊び方－
この説明の後ろに、プログラムが記載されています。

1.「float Hikaru  = 1;」の行の"1"は、ゲームスタートの時に、それぞれのLEDが光る時間を秒数で表しています。
  "1"だと、ゲームスタートの時に、それぞれのLEDが1秒づつ光ります。
  
2.「float Hayaku  = 0.15;」の行の"0.15"は、成功するたびにLEDの動きが少しづつ早くなる時間を秒数で表しています。
  "0.15"だと、成功するたびに、LEDの光る時間が0.15秒づつ短くなります。

3.「float Kaisu   = 4;」の行の"4"は、ゲームクリアしたときにLEDが点滅する回数を表しています。
　"4"だと、ゲームクリアしたときに、LEDの点滅は4回転します。

4.上に記載した３つの数字を書き換えて、30秒間でより多くの回数のゲームクリアができるように挑戦してみましょう。

＊注意:ゲームが成立しない数字に書き換えてしまった場合は、赤色LEDのみが点滅し、ゲームは始まりません。

[このサンプルスケッチは、Arduino IDE 1.8.5(Windows)で作成しました。]
＊IDEの[ファイル]>[環境設定]>[設定]タブ>"検証または書き込みを行う前にスケッチを保存する"にチェックがあると、
  自動保存で上書きされます。好みで使い分けてください。
*/

float Hikaru  = 1;
float Hayaku  = 0.15;
float Kaisu   = 4;

//----------ここから下は書き換えないでください----------
int interval; 
int delta;
int lap;

int vlm=0;
int sw=2;
int bz=3;
int led[] = { 0,9,6,5,10 };
//9-Green,6-Yellow,5-Red,10-Blue
int Timer;
bool passed=false;
unsigned long setTime;
unsigned long gameTime;

void setup() {
  interval = Hikaru*1000;
  delta = Hayaku*1000;
  lap = Kaisu; 
  //Serial.begin(9600);  
  pinMode(sw,INPUT);//setup input
  for (int i=1; i<5; i++){
    pinMode(led[i], OUTPUT);//setup output
  }
  if(interval<=delta*4 || lap<1)Crash();//check Crash
  gameTime = millis();
}

void loop() {
  while(analogRead(vlm)<512){
    gameTime = millis();
  }
  GameStart:
  //Serial.println("GameStart");
  Timer = interval; 
  for(int i=1; i<6; i++){
    for(int j=1; j<5; j++){
      digitalWrite(led[j],HIGH);
      setTime = millis();
      while((millis()-setTime)<Timer){
        if(digitalRead(sw)==LOW && j!=4){
          GameOver();
          goto GameStart;
        }
        if(digitalRead(sw)==LOW && j==4 && passed==false){
          passed=true;
          tone(bz,440,50);
        }
      }
      digitalWrite(led[j],LOW);
      if(30000<(millis()-gameTime) && i==5 && passed==true){
        GameClear();
        End();
        goto GameStart;
      }
      else if(30000<(millis()-gameTime)){
        End();
        goto GameStart;
      }
    }
    if(passed==true){
      Timer -= delta;
      passed = false;
    }
    else{
      GameOver();
      goto GameStart;
    }
  }
  GameClear();
}

void GameClear(){
  //Serial.println("GameClear");
  tone(bz,660);
  for (int i=1; i<=lap; i++){
    for (int j=4; j>0; j--){
      digitalWrite(led[j],HIGH);
      delay(100);
      digitalWrite(led[j],LOW);
    }
  }
  noTone(bz);
}

void GameOver(){
  //Serial.println("GameOver");
  for (int i=1; i<5; i++){
    digitalWrite(led[i],LOW);
  }
  tone(bz,220,1000);
  delay(1500);
}

void End(){
  //Serial.println("End");
  passed = false;
  int i=1;
  while(analogRead(vlm)>511){
    for (int j=1; j<5; j++){
      digitalWrite(led[j],i);
    }
    delay(500);
    i = 1-i;
  }
  for (int j=1; j<5; j++){
    digitalWrite(led[j],LOW);
  }
  while(analogRead(vlm)<512){
    gameTime = millis();
  }
}

void Crash(){
  //Serial.println("Crash");
  int i=1;
  while(1){
    digitalWrite(led[3],i);
    delay(500);
    i = 1-i;
  }
}
